/*********************************************************************************************
Copyright <2024> <Icore Technology (Nanjing)  Co.,Ltd>
All Rights Reserved,
Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice, this list of
conditions and the following disclaimer in the documentation and/or other materials provided 
with the distribution.
3. Neither the name of the copyright holder nor the names of its contributors may be used to 
endorse or promote products derived from this software without specific prior written
permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS 
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************************************/

/*
*********************************************************************************************************
*                                              rx32h6xx
*                                           Library Function
*
*                                   Copyright 2024, RX Tech, Corp.
*                                        All Rights Reserved
*
*
* Project      : rx32h6xx
* File         : main.c
* By           : RX_SD_Team
* Version      : V1.0.0
* Description  : Only rx32h6xx
*********************************************************************************************************
*/
#include "main.h"

/*
*********************************************************************************************************
*                                           Global macro/Structure
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                             Global variable
*********************************************************************************************************
*/
uint32_t count=0;
#define systick_1KHz 1000
/*
*********************************************************************************************************
*                                           Global Function declaration
*********************************************************************************************************
*/


void Delay_us( uint32_t us )
{
  uint32_t Fsys;
	Fsys=RCC_Get_SystemClock()/1000000;
	if( us*Fsys > SysTick_LOAD_RELOAD_Msk ) return;
	SysTick->CTRL = 0;      //Disable SysTick
	SysTick->LOAD = Fsys*us;//Set count number:72*us, 72 means 1us when SystemCoreClock is 72MHz
	SysTick->VAL  = 0;      //Clear current count number and count flag
	SysTick->CTRL = 5;      //Enable SysTick and Select SystemCoreClock as SysTick clock source
	while((SysTick->CTRL&0x10000)==0);//Wait for count flag set
	SysTick->CTRL = 0;      //Disable SysTick
}

void Delay_ms( uint32_t ms )
{
	uint32_t i;
	for(i=ms;i>0;i--)
	{
		Delay_us(1000);
	}
}

void SystemClock_Config(void)
{
	// set flash lantency
	FLASH_Set_Latency(FLASH_Latency_3);
	
  RCC_Enable_HSI();
  while(RCC_Get_HSIRDY() != 1)
  {
  }
  RCC_Set_PLLMUL(RCC_CFGR_PLLMUL_19x);
  RCC_Enable_PLL();
  while(RCC_Get_PLLRDY() != 1)
  {
  }
  RCC_Set_AHBPrescaler(RCC_CFGR_HPRE_DIV1);
  RCC_Set_APB1Prescaler(RCC_CFGR_PPRE1_DIV2);
  RCC_Set_APB2Prescaler(RCC_CFGR_PPRE2_DIV1);
  RCC_Set_SysClkSource(RCC_CFGR_SW_PLL);
  while(RCC_Get_SysClkSource() != RCC_CFGR_SWS_PLL)
  {
  }
  RCC_Set_ADCClkSource(RCC_CFGR_ADCCLK_SEL_PLL2);
  RCC_Set_ADCPrescaler(RCC_CFGR_ADCPRE_DIV5);
}

void TIM2_GPIO_Config(void)
{ 
  /*
  TIM2:
  CH2 :PB1_AF5
  */ 
  RCC_Enable_AHBClock(RCC_AHBENR_IOPBEN); 

  //CH2:PB1_AF5
  GPIO_Set_PinMode(GPIOB, GPIO_PIN_1, GPIO_MODE_AF_PP);
  GPIO_Set_PinOutSpeed(GPIOB, GPIO_PIN_1, GPIO_OSPEEDR_High);
  GPIO_Set_PinOutputType(GPIOB, GPIO_PIN_1, GPIO_OTYPER_OUT_Pushpull);
  GPIO_Set_PinPull(GPIOB, GPIO_PIN_1, GPIO_PUPDR_Floating);
  GPIO_Set_AF(GPIOB, GPIO_PIN_1, GPIO_AF5);
}

void TIM15_GPIO_Config(void)
{ 
  /*
  TIM15:
  CH1 :PC2_AF5
  */ 
  RCC_Enable_AHBClock(RCC_AHBENR_IOPCEN);  
  //CH1:PC2_AF5
  GPIO_Set_PinMode(GPIOC, GPIO_PIN_2, GPIO_MODE_AF_PP);
  GPIO_Set_PinOutSpeed(GPIOC, GPIO_PIN_2, GPIO_OSPEEDR_VeryHigh);
  GPIO_Set_PinOutputType(GPIOC, GPIO_PIN_2, GPIO_OTYPER_OUT_Pushpull);
  GPIO_Set_PinPull(GPIOC, GPIO_PIN_2, GPIO_PUPDR_Floating);
  GPIO_Set_AF(GPIOC, GPIO_PIN_2, GPIO_AF5);
}

void TIM2_PWMout(void)
{
  RCC_Enable_APB1Clock(RCC_APB1ENR_TIM2EN);//TIM2 Clock EN  
  TIM2_GPIO_Config();
  
  //SET CNT BASE
  TIM_Set_Prescaler(TIM2, TIM2_Prescaler);
  TIM_Set_AutoReload(TIM2, (TIM2_ARR-1));
  TIM_Set_RepetitionCounter(TIM2,0);
 
  //CH1 
  TIM_Set_OC_Mode(TIM2, TIM_CHANNEL_CH1, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIM2, TIM_CHANNEL_CH1, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH1(TIM2, TIM2_CCR);
  
  //CH2 
  TIM_Set_OC_Mode(TIM2, TIM_CHANNEL_CH2, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIM2, TIM_CHANNEL_CH2, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH2(TIM2, TIM2_CCR);
  
  //CH3 
  TIM_Set_OC_Mode(TIM2, TIM_CHANNEL_CH3, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIM2, TIM_CHANNEL_CH3, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH3(TIM2, TIM2_CCR);
  
  //CH4 
  TIM_Set_OC_Mode(TIM2, TIM_CHANNEL_CH4, TIM_OCMODE_PWM1);
  TIM_Set_OC_Polarity(TIM2, TIM_CHANNEL_CH4, TIM_OCPOLARITY_HIGH);
  TIM_Set_OC_CompareCH4(TIM2, TIM2_CCR);
  
  TIM_Set_ClockSource(TIM2,TIM_CLOCKSOURCE_INTERNAL);  
   
	/* Enable outputs OC1, OC2, OC3, OC4 */
  TIM_Enable_CC_Channel(TIM2, TIM_CHANNEL_CH1|TIM_CHANNEL_CH2|TIM_CHANNEL_CH3|TIM_CHANNEL_CH4); 
                        
  TIM_Enable_CEN(TIM2);
}

void TIM15_Capture(void)
{
  RCC_Enable_APB2Clock(RCC_APB2ENR_TIM15EN);//TIM15 Clock EN  
  TIM15_GPIO_Config();
  
  TIM_TimeBaseInitTypeDef TIM_TimeBaseInitStruct = {0};
  TIM_TimeBaseInitStruct.CounterMode       = TIM_COUNTERMODE_UP;
  TIM_TimeBaseInitStruct.RepetitionCounter = 0;
  TIM_TimeBaseInitStruct.Period        = 0xffff;
  TIM_TimeBaseInitStruct.ClockDivision = TIM_CLOCKDIVISION_DIV1;
  TIM_TimeBaseInitStruct.Prescaler     = 10;
  TIM_TimeBaseInit(TIM15, &TIM_TimeBaseInitStruct);
  
  TIM_ICInitTypeDef TIM_ICInitStruct = {0};
  TIM_ICInitStruct.Channel     = TIM_CHANNEL_CH1;
  TIM_ICInitStruct.ICSelection = TIM_ACTIVEINPUT_DIRECTTI;
  TIM_ICInitStruct.ICFilter    = TIM_IC_FILTER_FDIV1;
  TIM_ICInitStruct.ICPrescaler = TIM_ICPSC_DIV1;
  TIM_ICInitStruct.ICPolarity  = TIM_IC_POLARITY_RISING;
  TIM_ICInit(TIM15, &TIM_ICInitStruct); 
  TIM_ICInitStruct.Channel     = TIM_CHANNEL_CH2;
  TIM_ICInitStruct.ICSelection = TIM_ACTIVEINPUT_INDIRECTTI;
  TIM_ICInitStruct.ICPolarity  = TIM_IC_POLARITY_FALLING;
  TIM_ICInit(TIM15, &TIM_ICInitStruct); 
  
  TIM_Enable_CC_Channel(TIM15, TIM_CHANNEL_CH1);
  TIM_Enable_CC_Channel(TIM15, TIM_CHANNEL_CH2);
  
  TIM_Set_TriggerInput(TIM15, TIM_SMCR_TS_TI1FP1);
  TIM_Set_SlaveMode(TIM15, TIM_SMCR_SMS_RESET);
  
  //SET interruppt
  TIM_Enable_IT(TIM15,TIM_DIER_UIE);
  TIM_Enable_IT(TIM15,TIM_DIER_CC1IE);  
  TIM_Enable_IT(TIM15,TIM_DIER_CC2IE);  
  
  TIM_Set_GenerateEvent(TIM15,TIM_EGR_UG); 
  TIM_Clear_Flag(TIM15,TIM_SR_CC1IF);
  TIM_Clear_Flag(TIM15,TIM_SR_CC2IF);
  TIM_Clear_Flag(TIM15,TIM_SR_UIF); 
  TIM_Enable_CEN(TIM15); 
}


uint32_t RCC_Get_TIMClock(TIM_TypeDef *TIMx)
{
  uint32_t TIMClock;
  if((TIMx==TIM2)||(TIMx==TIM3)||(TIMx==TIM6)||(TIMx==TIM7))
  {
    if((RCC_Get_APB1Prescaler() >> 8)==0)TIMClock=RCC_Get_APB1Clock();
    else TIMClock=RCC_Get_APB1Clock()*2;   
  }
  else
  {
    if((RCC_Get_APB2Prescaler() >> 11)==0)TIMClock=RCC_Get_APB2Clock();
    else TIMClock=RCC_Get_APB2Clock()*2;
  }
  return TIMClock;
}


void UART2_Init_Async( uint32_t baudrate )
{
	GPIO_InitTypeDef GPIO_InitStruct  = {0};
	UART_InitTypeDef UART_InitStruct = {0};
	
	RCC_Enable_AHBClock(RCC_AHBENR_IOPDEN);
  RCC_Enable_AHBClock(RCC_AHBENR_IOPAEN);
	RCC_Enable_APB1Clock(RCC_APB1ENR_UART2EN);

	UART_InitStruct.BaudRate             = baudrate;
	UART_InitStruct.DataWidth            = UART_DATAWIDTH_8B;
	UART_InitStruct.Parity               = UART_PARITY_NONE;
	UART_InitStruct.StopBits             = UART_STOPBITS_1;
	UART_InitStruct.TransferDirection    = UART_DIRECTION_TX_RX;
	UART_Init(UART2,&UART_InitStruct);

  //PD5  -> UART2_TX
	//PD4  -> UART2_RX
	GPIO_InitStruct.Alternate = GPIO_AF5;
	GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
  GPIO_InitStruct.Pull      = GPIO_PUPDR_Pullup;
	GPIO_InitStruct.Speed     = GPIO_OSPEEDR_High;
	GPIO_InitStruct.Pin       = GPIO_PIN_4;
	GPIO_Init(GPIOD, &GPIO_InitStruct);
	GPIO_InitStruct.Pull      = GPIO_PUPDR_Floating;
	GPIO_InitStruct.Pin       = GPIO_PIN_5;
	GPIO_Init(GPIOD, &GPIO_InitStruct);

	UART_Enable(UART2);
}

uint32_t duty=0;
int main(void)
{
  uint32_t duty=0;
  SystemClock_Config();
  RCC_Enable_AHBClock(RCC_AHBENR_IOPAEN|RCC_AHBENR_IOPBEN| RCC_AHBENR_IOPCEN|RCC_AHBENR_IOPDEN);  
  TIM15_Capture();
  TIM2_PWMout();
  UART2_Init_Async(115200);
  
  SysTick_Config(RCC_Get_SystemClock()/systick_1KHz);
  
  while(1)
  {
    if(count)
    {
      count = 0;
      duty=TIM_CaptureDuty(TIM15);
      
      printf("duty=%d\r\n",duty);      
    }
  }
}


