/*********************************************************************************************
Copyright <2024> <Icore Technology (Nanjing)  Co.,Ltd>
All Rights Reserved,
Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice, this list of
conditions and the following disclaimer in the documentation and/or other materials provided 
with the distribution.
3. Neither the name of the copyright holder nor the names of its contributors may be used to 
endorse or promote products derived from this software without specific prior written
permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS 
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************************************/

/*
*********************************************************************************************************
*                                              rx32h6xx
*                                           Library Function
*
*                                   Copyright 2024, RX Tech, Corp.
*                                        All Rights Reserved
*
*
* Project      : rx32h6xx
* File         : main.c
* By           : RX_SD_Team
* Version      : V1.0.0
* Description  : Only rx32h6xx
*********************************************************************************************************
*/
#include "main.h"

/*
*********************************************************************************************************
*                                           Global macro/Structure
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                             Global variable
*********************************************************************************************************
*/
uint8_t txbuff[5] = {0x30,0x31,0x32,0x33,0x34};

/*
*********************************************************************************************************
*                                           Global Function declaration
*********************************************************************************************************
*/

void Delay_us( uint32_t us )
{
	uint32_t Fsys;
	Fsys=RCC_Get_SystemClock()/1000000; 
	if( us*Fsys > SysTick_LOAD_RELOAD_Msk ) return;
	SysTick->CTRL = 0;      //Disable SysTick
	SysTick->LOAD = Fsys*us;//Set count number:72*us, 72 means 1us when SystemCoreClock is 72MHz
	SysTick->VAL  = 0;      //Clear current count number and count flag
	SysTick->CTRL = 5;      //Enable SysTick and Select SystemCoreClock as SysTick clock source
	while((SysTick->CTRL&0x10000)==0);//Wait for count flag set
	SysTick->CTRL = 0;      //Disable SysTick
}

void Delay_ms( uint32_t ms )
{
	uint32_t i;
	for(i=ms;i>0;i--)
	{
		Delay_us(1000);
	}
}

void SystemClock_Config(void)
{
	// set flash lantency
	FLASH_Set_Latency(FLASH_Latency_3);
	
  RCC_Enable_HSI();
  while(RCC_Get_HSIRDY() != 1)
  {
  }
  RCC_Set_PLLMUL(RCC_CFGR_PLLMUL_19x);
  RCC_Enable_PLL();
  while(RCC_Get_PLLRDY() != 1)
  {
  }
  RCC_Set_AHBPrescaler(RCC_CFGR_HPRE_DIV1);
  RCC_Set_APB1Prescaler(RCC_CFGR_PPRE1_DIV2);
  RCC_Set_APB2Prescaler(RCC_CFGR_PPRE2_DIV1);
  RCC_Set_SysClkSource(RCC_CFGR_SW_PLL);
  while(RCC_Get_SysClkSource() != RCC_CFGR_SWS_PLL)
  {
  }
  RCC_Set_ADCClkSource(RCC_CFGR_ADCCLK_SEL_PLL2);
  RCC_Set_ADCPrescaler(RCC_CFGR_ADCPRE_DIV5);
}



void UART1_Init_Async( uint32_t baudrate )
{
	GPIO_InitTypeDef GPIO_InitStruct  = {0};
	UART_InitTypeDef UART_InitStruct = {0};
	
	RCC_Enable_AHBClock(RCC_AHBENR_IOPDEN);
  RCC_Enable_AHBClock(RCC_AHBENR_IOPAEN);
	RCC_Enable_APB2Clock(RCC_APB2ENR_UART1EN);

	UART_InitStruct.BaudRate             = baudrate;
	UART_InitStruct.DataWidth            = UART_DATAWIDTH_8B;
	UART_InitStruct.Parity               = UART_PARITY_NONE;
	UART_InitStruct.StopBits             = UART_STOPBITS_1;
	UART_InitStruct.TransferDirection    = UART_DIRECTION_TX;
	UART_Init(UART1,&UART_InitStruct);

  //PA1  -> UART1_TX
	//PA0  -> UART1_RX
	GPIO_InitStruct.Alternate = GPIO_AF5;
	GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
  GPIO_InitStruct.Pull      = GPIO_PUPDR_Pullup;
	GPIO_InitStruct.Speed     = GPIO_OSPEEDR_High;
	GPIO_InitStruct.Pin       = GPIO_PIN_0;
	GPIO_Init(GPIOA, &GPIO_InitStruct);
	GPIO_InitStruct.Pull      = GPIO_PUPDR_Pullup;
	GPIO_InitStruct.Pin       = GPIO_PIN_1;
	GPIO_Init(GPIOA, &GPIO_InitStruct);

  UART_Enable_LIN(UART1);
  UART_Enable(UART1);
}

uint8_t LIN_GetPID(uint8_t ID)      //PID
{
  uint8_t PID = 0, P0 = 0, P1 = 0;
  P0 = (((ID >> 0) ^ (ID >> 1) ^ (ID >> 2) ^ (ID >> 4)) & 0x01) << 6;
  P1 = ((~((ID >> 1) ^ (ID >> 3) ^ (ID >> 4) ^ (ID >> 5))) & 0x01) << 7;
  PID = (ID | P0 | P1);
  return PID;
}

uint8_t LIN_GetChecksum(uint8_t PID, uint8_t* pData, uint8_t DataLen)   //У
{
  uint16_t CheckSum = 0;
  if((PID != 0x3C) && (PID != 0x7D))
  {
    CheckSum = PID;
  }
  for(uint8_t i = 0; i < DataLen; i++)
  {
    CheckSum += pData[i];
    if(CheckSum > 0xFF)
    {
      CheckSum -= 0xFF;
    }
  }
  return (~CheckSum) & 0xFF;
}

void LIN_SendMsg(UART_TypeDef* UARTx, uint8_t FrameID, uint8_t* pData, uint8_t DataLen, uint16_t Times)  //
{
  uint8_t PID = LIN_GetPID(FrameID);	//FrameIDPID
  uint8_t Checksum = LIN_GetChecksum(PID, pData, DataLen); 	//У

  uint8_t Linbuffer[DataLen + 3];
  Linbuffer[0] = 0x55;
  Linbuffer[1] = PID;
  Linbuffer[DataLen + 2] = Checksum;

  for(uint8_t i = 0; i < Times; i++)
  {
    while(UART_Get_Flag(UART1, UART_FLAG_TXE) == 0);
    UART_Request_BreakSending(UARTx);

    while(UART_Get_Flag(UART1, UART_FLAG_TXE) == 0);
    UART_Transmit_Data8(UARTx, Linbuffer[0]);
    Delay_us(121);
      
    while(UART_Get_Flag(UART1, UART_FLAG_TXE) == 0);
    UART_Transmit_Data8(UARTx, Linbuffer[1]);
    Delay_us(173);
      
    for(uint8_t i = 0; i < DataLen; i++)
    {
      Linbuffer[i + 2] = *(pData + i);
      while(UART_Get_Flag(UART1, UART_FLAG_TXE) == 0);
      UART_Transmit_Data8(UARTx, Linbuffer[i + 2]);
    }
    Delay_us(120);
    
    while(UART_Get_Flag(UART1, UART_FLAG_TXE) == 0);
    UART_Transmit_Data8(UARTx, Linbuffer[DataLen + 2]);
    while(UART_Get_Flag(UART1, UART_FLAG_TXE) == 0);
    Delay_ms(12);
  }
}

int main(void)
{
  SystemClock_Config();
  
  UART1_Init_Async(19200);
  
  LIN_SendMsg(UART1, 0x31, txbuff, 5, 1); 
  
  while(1)
  {
     
  }
}
