/*********************************************************************************************
Copyright <2024> <Icore Technology (Nanjing)  Co.,Ltd>
All Rights Reserved,
Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice, this list of
conditions and the following disclaimer in the documentation and/or other materials provided 
with the distribution.
3. Neither the name of the copyright holder nor the names of its contributors may be used to 
endorse or promote products derived from this software without specific prior written
permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS 
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************************************/

/*
*********************************************************************************************************
*                                              rx32s61xx
*                                           Library Function
*
*                                   Copyright 2024, RX Tech, Corp.
*                                        All Rights Reserved
*
*
* Project      : rx32s61xx
* File         : main.c
* By           : RX_SD_Team
* Version      : V1.0.0
* Description  : Only rx32s61xx
*********************************************************************************************************
*/
#include "main.h"

/*
*********************************************************************************************************
*                                           Global macro/Structure
*********************************************************************************************************
*/

#define ADC_convert_frequency	 	20   											//ADC ����Ƶ�� �� 20 kHz

#define TIM_PSC 								151												//TIM8 ��Ƶϵ��
#define F_TIM8 									152000000/(TIM_PSC+1)			//TIM8 ʱ��Ƶ��
#define TIM_ARR 								F_TIM8/(ADC_convert_frequency*1000)		//����װ��ֵ
#define TIM_CCR 								TIM_ARR/2

/*
*********************************************************************************************************
*                                             Global variable
*********************************************************************************************************
*/

uint32_t  DataArray[ArrayLength] = {0};
uint32_t  j = 0;
uint32_t 	Data_Array_empty = 0;
/*
*********************************************************************************************************
*                                           Global Function declaration
*********************************************************************************************************
*/



void Delay_us( uint32_t us )
{
  uint32_t Fsys;
	Fsys=RCC_Get_SystemClock()/1000000;
	//maximum:199728us 
	if( us*Fsys > SysTick_LOAD_RELOAD_Msk ) return;
	SysTick->CTRL = 0;      //Disable SysTick
	SysTick->LOAD = Fsys*us;//Set count number:72*us, 72 means 1us when SystemCoreClock is 72MHz
	SysTick->VAL  = 0;      //Clear current count number and count flag
	SysTick->CTRL = 5;      //Enable SysTick and Select SystemCoreClock as SysTick clock source
	while((SysTick->CTRL&0x10000)==0);//Wait for count flag set
	SysTick->CTRL = 0;      //Disable SysTick
}

void Delay_ms( uint32_t ms )
{
	uint32_t i;
	for(i=ms;i>0;i--)
	{
		Delay_us(1000);
	}
}

void SystemClock_Config(void)
{
	// set flash lantency
	FLASH_Set_Latency(FLASH_Latency_3);
	
  RCC_Enable_HSI();
  while(RCC_Get_HSIRDY() != 1)
  {
  }
  RCC_Set_PLLMUL(RCC_CFGR_PLLMUL_19x);
  RCC_Enable_PLL();
  while(RCC_Get_PLLRDY() != 1)
  {
  }
  RCC_Set_AHBPrescaler(RCC_CFGR_HPRE_DIV1);
  RCC_Set_APB1Prescaler(RCC_CFGR_PPRE1_DIV2);
  RCC_Set_APB2Prescaler(RCC_CFGR_PPRE2_DIV1);
  RCC_Set_SysClkSource(RCC_CFGR_SW_PLL);
  while(RCC_Get_SysClkSource() != RCC_CFGR_SWS_PLL)
  {
  }
  RCC_Set_ADCClkSource(RCC_CFGR_ADCCLK_SEL_PLL2);
  RCC_Set_ADCPrescaler(RCC_CFGR_ADCPRE_DIV5);
}

void ADC_GPIO_Init(void)
{
	RCC_Enable_AHBClock(RCC_AHBENR_IOPCEN);
	
  GPIO_InitTypeDef  GPIO_InitStruct = {0};
  GPIO_InitStruct.Mode 				= GPIO_MODE_ANALOG;
  GPIO_InitStruct.Pull 				= GPIO_PUPDR_Floating;
  GPIO_InitStruct.Speed 			= GPIO_OSPEEDR_High;
	GPIO_InitStruct.Alternate 	= GPIO_AF0;
	
  GPIO_InitStruct.Pin = GPIO_PIN_2;											//PC2    ADC channel 2
  GPIO_Init(GPIOC,&GPIO_InitStruct);
}

void ADC_Init(ADC_TypeDef *ADCx, uint32_t Channel, uint32_t SamplingTime, uint32_t TriggerSource)
{
	RCC_Enable_AHBClock(RCC_AHBENR_ADC1EN);
	ADC_GPIO_Init();
	
	ADC_Inj_InitTypeDef  ADC_Inj_InitStruct = {0};
	ADC_INJ_RankInitTypeDef  ADC_INJ_RankInitStruct = {0};
	
	ADC_Inj_InitStruct.TriggerSource  	 					= TriggerSource;
	ADC_Inj_InitStruct.ScanMode    								= ADC_CR1_SCAN_DISABLE;
	ADC_Inj_InitStruct.DataAlignment 							= ADC_CR2_ALIGN_RIGHT;
	ADC_Inj_InitStruct.TrigAuto  									= ADC_CR1_JAUTO_INDEPENDENT;
	ADC_Inj_InitStruct.AnalogWatchDog 						= ADC_CR1_AWD_DISABLE;
	ADC_Inj_InitStruct.AWDChannelGroup						= ADC_AWD_DISABLE;
	ADC_Inj_InitStruct.InjectDiscont							=	ADC_CR1_JDISCEN_DISABLE;
	ADC_Inj_InitStruct.EOCOption									= ADC_EOC_OPT_DISABLE;
	ADC_Inj_Init(ADC1, &ADC_Inj_InitStruct);
	
	ADC_INJ_RankInitStruct.Length 								= ADC_JSQRL_SCAN_1RANK;
	ADC_INJ_RankInitStruct.Rank[0].Channel  			= Channel;
	ADC_INJ_RankInitStruct.Rank[0].SamplingTime   = SamplingTime;
	ADC_INJ_RankInit(ADC1, &ADC_INJ_RankInitStruct);
	
	
	NVIC_SetPriority(ADC_IRQn, 1);			//�����ж����ȼ�
	NVIC_EnableIRQ(ADC_IRQn);						//ʹ�� ADC �ж�
  
  /* Enable ADC */
  ADC_Enable_ADON(ADCx);
	
	Delay_us(200);

	/* Run ADC self calibration */
	ADC_Trig_CAL(ADCx);
	while (ADC_Get_CAL(ADCx) != 0);

	
	ADC_Enable_IT(ADC1,ADC_CR1_JEOCIE);
	
	
	/* Clear flag ADC group regular end of unitary conversion */
	ADC_Clear_SR(ADCx,ADC_SR_JEOC);
	

	/*wait flag ADC group regular end of unitary conversion */
	while (ADC_Get_SR(ADCx,ADC_SR_EOC) == 0);
	
  /* Disable ADC */
  //ADC_Disable_ADON(ADCx);
}


void UART2_Init_Async( uint32_t baudrate )     // UART2  initial
{
	//PD4  -> UART2_RX
	//PD5  -> UART2_TX
	
	GPIO_InitTypeDef GPIO_InitStruct  = {0};
	UART_InitTypeDef UART_InitStruct = {0};
	
	RCC_Enable_AHBClock(RCC_AHBENR_IOPDEN);
	RCC_Enable_APB1Clock(RCC_APB1ENR_UART2EN);

	UART_InitStruct.BaudRate             = baudrate;
	UART_InitStruct.DataWidth            = UART_DATAWIDTH_8B;
	UART_InitStruct.Parity               = UART_PARITY_NONE;
	UART_InitStruct.StopBits             = UART_STOPBITS_1;
	UART_InitStruct.TransferDirection    = UART_DIRECTION_TX_RX;
	UART_Init(UART2,&UART_InitStruct);

	GPIO_InitStruct.Alternate = GPIO_AF5;
	GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
	GPIO_InitStruct.Pull      = GPIO_PUPDR_Pullup;
	GPIO_InitStruct.Speed     = GPIO_OSPEEDR_High;
	GPIO_InitStruct.Pin       = GPIO_PIN_4;
	GPIO_Init(GPIOD, &GPIO_InitStruct);
	
	GPIO_InitStruct.Alternate = GPIO_AF5;
	GPIO_InitStruct.Mode      = GPIO_MODE_AF_PP;
	GPIO_InitStruct.Pull      = GPIO_PUPDR_Floating;
	GPIO_InitStruct.Speed     = GPIO_OSPEEDR_High;
	GPIO_InitStruct.Pin       = GPIO_PIN_5;
	GPIO_Init(GPIOD, &GPIO_InitStruct);

	UART_Enable(UART2);
}

	
void TIM8_GPIO_Config(void)
{
	GPIO_InitTypeDef        GPIO_InitStruct = {0};
	GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
	GPIO_InitStruct.Pull = GPIO_PUPDR_Floating;
	GPIO_InitStruct.Speed = GPIO_OSPEEDR_High;
	
	GPIO_InitStruct.Alternate = GPIO_AF1;
	GPIO_InitStruct.Pin = GPIO_PIN_3;											//PD3(AF1)    TIM8CH1
	GPIO_Init(GPIOD,&GPIO_InitStruct);
}
	
	
void TIM_Init(TIM_TypeDef *TIMx, uint16_t psc, uint16_t arr, uint16_t ccr)
{
	RCC_Enable_APB2Clock(RCC_APB2ENR_TIM8EN);
	TIM8_GPIO_Config();

	//SET CNT BASE
	TIM_Set_CounterMode(TIMx,TIM_COUNTERMODE_UP);
	
	TIM_Set_AutoReload(TIMx,arr);
	TIM_Set_Prescaler(TIMx,psc);
	
	TIM_Disable_ARRPreload(TIMx);
	TIM_Set_ClockSource(TIMx,TIM_CLOCKSOURCE_INTERNAL);

	//SET Channel output 
	TIM_Set_OC_Mode(TIMx,TIM_CHANNEL_CH1,TIM_OCMODE_PWM1);

	TIM_Set_OC_CompareCH1(TIMx,ccr/12);  
 
	TIM_Enable_CC_Channel(TIMx,TIM_CHANNEL_CH1);    

	TIM_Set_TriggerOutput(TIMx, TIM_TRGO_UPDATE);
	
	//SET interruppt

	TIM_Enable_IT(TIMx,TIM_DIER_UIE);
	TIM_Enable_IT(TIMx,TIM_DIER_CC1IE);

	TIM_Set_GenerateEvent(TIMx,TIM_EGR_UG);
	TIM_Clear_Flag(TIMx,TIM_SR_UIF);
	
	TIM_Enable_MOE(TIMx);
	TIM_Enable_CEN(TIMx);

}

void convert_result_print(void)
{
	int array_num = 0;
	while(array_num<ArrayLength)
	{
		printf("convert channel %d result is 0x%x\r\n",ADC_CHANNEL_2&0x1F, DataArray[array_num]);
		array_num++;
	}
	printf("\r\n");
}

int main(void)
{  
	SystemClock_Config();
	UART2_Init_Async(115200);
	TIM_Init(TIM8, TIM_PSC, TIM_ARR, TIM_CCR); 
	ADC_Init(ADC1,ADC_CHANNEL_2,ADC_SAMPLINGTIME_2p5CYCLES,ADC_CR2_JEXTSEL_TIM8_TRGO1);

	while(1)
	{
		if(Data_Array_empty == 0)
		{
			ADC_Enable_IT(ADC1,ADC_CR1_JEOCIE);
			convert_result_print();
			Data_Array_empty = 1;
		}
	}
}
