/*********************************************************************************************
Copyright <2024> <Icore Technology (Nanjing)  Co.,Ltd>
All Rights Reserved,
Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice, this list of
conditions and the following disclaimer in the documentation and/or other materials provided 
with the distribution.
3. Neither the name of the copyright holder nor the names of its contributors may be used to 
endorse or promote products derived from this software without specific prior written
permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS 
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************************************/

/*
*********************************************************************************************************
*                                              rx32s61xx
*                                           Library Function
*
*                                   Copyright 2024, RX Tech, Corp.
*                                        All Rights Reserved
*
*
* Project      : rx32s61xx
* File         : main.c
* By           : RX_SD_Team
* Version      : V1.0.0
* Description  : Only rx32s61xx
*********************************************************************************************************
*/
#include "main.h"

/*
*********************************************************************************************************
*                                           Global macro/Structure
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                             Global variable
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                           Global Function declaration
*********************************************************************************************************
*/

void Delay_us( uint32_t us )
{
  uint32_t Fsys;
	Fsys=RCC_Get_SystemClock()/1000000;
	//maximum:199728us 
	if( us*Fsys > SysTick_LOAD_RELOAD_Msk ) return;
	SysTick->CTRL = 0;      //Disable SysTick
	SysTick->LOAD = Fsys*us;//Set count number:72*us, 72 means 1us when SystemCoreClock is 72MHz
	SysTick->VAL  = 0;      //Clear current count number and count flag
	SysTick->CTRL = 5;      //Enable SysTick and Select SystemCoreClock as SysTick clock source
	while((SysTick->CTRL&0x10000)==0);//Wait for count flag set
	SysTick->CTRL = 0;      //Disable SysTick
}

void Delay_ms( uint32_t ms )
{
	uint32_t i;
	for(i=ms;i>0;i--)
	{
		Delay_us(1000);
	}
}

void SystemClock_Config(void)
{
	// set flash lantency
	FLASH_Set_Latency(FLASH_Latency_3);
	
  RCC_Enable_HSI();
  while(RCC_Get_HSIRDY() != 1)
  {
  }
  RCC_Set_PLLMUL(RCC_CFGR_PLLMUL_19x);
  RCC_Enable_PLL();
  while(RCC_Get_PLLRDY() != 1)
  {
  }
  RCC_Set_AHBPrescaler(RCC_CFGR_HPRE_DIV1);
  RCC_Set_APB1Prescaler(RCC_CFGR_PPRE1_DIV2);
  RCC_Set_APB2Prescaler(RCC_CFGR_PPRE2_DIV1);
  RCC_Set_SysClkSource(RCC_CFGR_SW_PLL);
  while(RCC_Get_SysClkSource() != RCC_CFGR_SWS_PLL)
  {
  }
  RCC_Set_ADCClkSource(RCC_CFGR_ADCCLK_SEL_PLL2);
  RCC_Set_ADCPrescaler(RCC_CFGR_ADCPRE_DIV5);
}

void GPIO_Toggle(void)
{
  RCC_Enable_AHBClock(RCC_AHBENR_IOPBEN);
  
  GPIO_InitTypeDef GPIO_InitStruct = {0};
  GPIO_InitStruct.Alternate = GPIO_AF0;
  GPIO_InitStruct.Pin = GPIO_PIN_0;
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_PUPDR_Pullup;
  GPIO_InitStruct.Speed = GPIO_OSPEEDR_High;
  GPIO_Init(GPIOB,&GPIO_InitStruct);
	GPIO_InitStruct.Pin = GPIO_PIN_3;
	GPIO_Init(GPIOB,&GPIO_InitStruct);
}


void TIM8_GPIO_Config(void)
{
  /*CMU_Clock_EN*/  
  RCC_Enable_AHBClock(RCC_AHBENR_IOPCEN);
	
	//TIM8_CH4: PC5_AF1
  GPIO_Set_PinMode(GPIOC, GPIO_PIN_5, GPIO_MODE_AF_PP);
  GPIO_Set_PinOutSpeed(GPIOC, GPIO_PIN_5, GPIO_OSPEEDR_High);
  GPIO_Set_PinOutputType(GPIOC, GPIO_PIN_5, GPIO_OTYPER_OUT_Pushpull);
  GPIO_Set_PinPull(GPIOC, GPIO_PIN_5, GPIO_PUPDR_Floating);
  GPIO_Set_AF(GPIOC, GPIO_PIN_5, GPIO_AF1);  
}
	
	
void TIM8CH_Config(uint32_t arr,uint32_t psc,uint32_t ccr)
{
	RCC_Enable_APB2Clock(RCC_APB2ENR_TIM8EN); 

	TIM_Set_CounterMode(TIM8,TIM_COUNTERMODE_UP);
	TIM_Set_AutoReload(TIM8,arr);
	TIM_Set_Prescaler(TIM8,psc);  

	TIM_Set_OC_Mode(TIM8,TIM_CHANNEL_CH4,TIM_OCMODE_PWM1); 
		
	TIM_Set_OC_CompareCH4(TIM8,ccr);

	TIM_Enable_CC_Channel(TIM8,TIM_CHANNEL_CH4); 
    
  TIM_Enable_MOE(TIM8);
  TIM_Enable_CEN(TIM8);
}


	
void COMP1_PIN(void)
{
	/* COMP1_P1 -> PC0(Analog)  COMP1_P2 -> PB6(Analog)     	COMP1_P3 -> PB4(Analog) 
	   COMP1_N1 -> PC1(Analog)  COMP1_N2 -> PB7(Analog)       COMP1_N3 -> PB5(Analog) 

	  COMP1_O -> PA4(AF2)		       */
		GPIO_InitTypeDef GPIO_InitStruct = {0};
	/*--------COMP1----------*/
	GPIO_InitStruct.Mode = GPIO_MODER_MODER_Analog;
	GPIO_InitStruct.Pull = GPIO_PUPDR_Floating;
  GPIO_InitStruct.Speed = GPIO_OSPEEDR_High;
  GPIO_InitStruct.Alternate = GPIO_AF0;
  //COMP1_P1 -> PC0
	GPIO_InitStruct.Pin  = GPIO_PIN_0;
	GPIO_Init(GPIOC, &GPIO_InitStruct);
  //COMP1_N1 -> PC1
	GPIO_InitStruct.Pin  = GPIO_PIN_1;
	GPIO_Init(GPIOC, &GPIO_InitStruct);
  //COMP1_P2 -> PB6
  GPIO_InitStruct.Pin  = GPIO_PIN_6;
	GPIO_Init(GPIOB, &GPIO_InitStruct);
  //COMP1_N2 -> PB7
  GPIO_InitStruct.Pin  = GPIO_PIN_7;
	GPIO_Init(GPIOB, &GPIO_InitStruct);
	//COMP1_P3 -> PB4
  GPIO_InitStruct.Pin  = GPIO_PIN_4;
	GPIO_Init(GPIOB, &GPIO_InitStruct);
	//COMP1_N3 -> PB5
  GPIO_InitStruct.Pin  = GPIO_PIN_5;
	GPIO_Init(GPIOB, &GPIO_InitStruct);
  //COMP1_O -> PA4
	GPIO_InitStruct.Mode = GPIO_MODE_AF_PP;
	GPIO_InitStruct.Alternate   =  GPIO_AF2;
	GPIO_InitStruct.Pin  = GPIO_PIN_4;
	GPIO_Init(GPIOA, &GPIO_InitStruct);

}


void COMP1_CONFIG(void)
{

	/*--------CMP1 Initial Structure-------*/
	CMP_InitTypeDef CMP_InitStruct = {0};
	CMP_InitStruct.Pol  	  = CMP_CxCR_POL_Positive;
	CMP_InitStruct.OFLT 	  = CMP_CxCR_OFLT_DIV1;
	CMP_InitStruct.Rhyst	  = CMP_CxCR_RHYST_0mV;
	CMP_InitStruct.Fhyst	  = CMP_CxCR_FHYST_0mV;
	CMP_InitStruct.INM_Sel  = CMP_INM_SEL_N1;   
	CMP_InitStruct.INP_Sel  = CMP_INP_SEL_P1;		
	CMP_Init(COMP1, &CMP_InitStruct);
	CMP_Enable(COMP1);    //Enable COMP1 
}


int main(void)
{
  SystemClock_Config();
    
  RCC_Enable_AHBClock(RCC_AHBENR_IOPBEN |RCC_AHBENR_IOPAEN |RCC_AHBENR_IOPCEN|RCC_AHBENR_IOPDEN);
	RCC_Enable_APB2Clock(RCC_APB2ENR_SYSCFGEN); 
	  
  GPIO_Toggle();

	COMP1_PIN();
	COMP1_CONFIG();
		
  //Blanking 
  CMP_Set_BLANKING(COMP1,CMP_CxCR_BLANKING_SEL_TIM8_OC4);

	TIM8_GPIO_Config();
  TIM8CH_Config(100,5,49); 

  while(1)
  {
    GPIO_Toggle_Pin(GPIOB,GPIO_PIN_0);
    Delay_ms(100);
  }
}
