/*********************************************************************************************
Copyright <2024> <Icore Technology (Nanjing)  Co.,Ltd>
All Rights Reserved,
Redistribution and use in source and binary forms, with or without modification, are permitted
provided that the following conditions are met:
1. Redistributions of source code must retain the above copyright notice, this list of
conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice, this list of
conditions and the following disclaimer in the documentation and/or other materials provided 
with the distribution.
3. Neither the name of the copyright holder nor the names of its contributors may be used to 
endorse or promote products derived from this software without specific prior written
permission.
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS 
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED 
AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
OF THE POSSIBILITY OF SUCH DAMAGE.
**********************************************************************************************/

/*
*********************************************************************************************************
*                                              rx32s61xx
*                                           Library Function
*
*                                   Copyright 2024, RX Tech, Corp.
*                                        All Rights Reserved
*
*
* Project      : rx32s61xx
* File         : main.c
* By           : RX_SD_Team
* Version      : V1.0.0
* Description  : Only rx32s61xx
*********************************************************************************************************
*/
#include "main.h"
/*
*********************************************************************************************************
*                                           Global macro/Structure
*********************************************************************************************************
*/
/*
*********************************************************************************************************
*                                             Global variable
*********************************************************************************************************
*/

/*
*********************************************************************************************************
*                                           Global Function declaration
*********************************************************************************************************
*/

void SystemClock_Config(void)
{
	FLASH_Set_Latency(FLASH_Latency_3);
	
  RCC_Enable_HSI();
  while(RCC_Get_HSIRDY() != 1)
  {
  }
  RCC_Set_PLLMUL(RCC_CFGR_PLLMUL_19x);
  RCC_Enable_PLL();
  while(RCC_Get_PLLRDY() != 1)
  {
  }
  RCC_Set_AHBPrescaler(RCC_CFGR_HPRE_DIV1);
  RCC_Set_APB1Prescaler(RCC_CFGR_PPRE1_DIV2);
  RCC_Set_APB2Prescaler(RCC_CFGR_PPRE2_DIV1);
  RCC_Set_SysClkSource(RCC_CFGR_SW_PLL);
  while(RCC_Get_SysClkSource() != RCC_CFGR_SWS_PLL)
  {
  }
  RCC_Set_ADCClkSource(RCC_CFGR_ADCCLK_SEL_PLL2);
  RCC_Set_ADCPrescaler(RCC_CFGR_ADCPRE_DIV5);
}

void GPIO_Toggle(void)
{
  RCC_Enable_AHBClock(RCC_AHBENR_IOPBEN);
  
  GPIO_InitTypeDef GPIO_InitStruct = {0};
  GPIO_InitStruct.Mode = GPIO_MODE_OUTPUT_PP;
  GPIO_InitStruct.Pull = GPIO_PUPDR_Pullup;
  GPIO_InitStruct.Speed = GPIO_OSPEEDR_High;
  GPIO_InitStruct.Alternate = GPIO_AF0;
  GPIO_InitStruct.Pin = GPIO_PIN_1;	
  GPIO_Init(GPIOB,&GPIO_InitStruct);
  GPIO_InitStruct.Pin = GPIO_PIN_2;
  GPIO_Init(GPIOB,&GPIO_InitStruct);
}

int main(void)
{
  uint32_t Arg1=9,Arg2=3;
  uint32_t result1,result2,result3;
  
  SystemClock_Config();
  GPIO_Toggle();
  RCC_Enable_AHBClock(RCC_AHBENR_MEEN);
  
  result1 = ME_UDIV(Arg1, Arg2);
  result2 = ME->ARG2;
  if(result1!=3)GPIO_Toggle_Pin(GPIOB,GPIO_PIN_1);
  else GPIO_Toggle_Pin(GPIOB,GPIO_PIN_2);
  if(result2!=0)GPIO_Toggle_Pin(GPIOB,GPIO_PIN_1);
  else GPIO_Toggle_Pin(GPIOB,GPIO_PIN_2);
  
  result3 = ME_SQRT(Arg1);
  if(result3!=3)GPIO_Toggle_Pin(GPIOB,GPIO_PIN_1);
  else GPIO_Toggle_Pin(GPIOB,GPIO_PIN_2);
  
  while(1)
  {
  }
}

